<?php
require '../db_config.php';
session_start();

$user_id = $_SESSION['user_id'];
$app_id = $_GET['app_id'] ?? null;

if (!$app_id) {
    die("Invalid request.");
}

// Generate a new API Key
$new_api_key = bin2hex(random_bytes(16));

$stmt = $pdo->prepare("UPDATE registered_apps SET api_key = ? WHERE user_id = ? AND app_id = ?");
$stmt->execute([$new_api_key, $user_id, $app_id]);

$_SESSION['flash_message'] = "API key regenerated successfully.";
header("Location: manage_api_keys.php");
exit();
?>
