<?php
require '../vendor/autoload.php';
require '../db_config.php';
require 'authenticate.php'; // Secure API

header("Content-Type: application/json");

// Authenticate user
$user_id = authenticate(); // Authenticated user ID

// Get request data
$data = json_decode(file_get_contents("php://input"), true);
$app_name = trim($data['app_name'] ?? '');

if (!$app_name) {
    echo json_encode(["error" => "App name is required"]);
    exit;
}

// Generate a unique app_id and API key
$app_id = bin2hex(random_bytes(8)); // 16-character unique ID
$api_key = bin2hex(random_bytes(32)); // 64-character secure API key

// Store app details in the database
$stmt = $pdo->prepare("INSERT INTO registered_apps (user_id, app_id, app_name, api_key) VALUES (?, ?, ?, ?)");
$stmt->execute([$user_id, $app_id, $app_name, $api_key]);

echo json_encode([
    "message" => "App registered successfully",
    "app_id" => $app_id,
    "app_name" => $app_name,
    "api_key" => $api_key
]);
?>
