<?php
include 'header.php';
include 'db.php';

$user_id = $_SESSION['user_id'];

// Fetch the user's QR code path from the database
$stmt = $conn->prepare("SELECT qr_code_path FROM authentications WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$qrCodePath = $row['qr_code_path'] ?? null;
$stmt->close();
$conn->close();
?>





<h2 class="mb-4">Welcome to Your Dashboard</h2>

<?php
if (isset($_SESSION['flash_message'])) {
    echo '<div class="alert alert-success">' . $_SESSION['flash_message'] . '</div>';
    unset($_SESSION['flash_message']);
}
?>

<div class="row">
    <div class="col-md-4">
        <?php if (!$qrCodePath): ?>
            <a href="generate_qr.php" class="btn btn-primary w-100 mb-3">Generate OTP</a>
        <?php endif; ?>
    </div>

    <!--
    <div class="col-md-4">
        <a href="validate_otp.php" class="btn btn-warning w-100 mb-3">Validate OTP</a>
    </div>
    <div class="col-md-4">
        <a href="scan_qr.php" class="btn btn-info w-100 mb-3">Scan QR</a>
    </div>

    <div class="col-md-4">
        <a href="generate_scanned_otp.php" class="btn btn-success w-100 mb-3">Generate OTP for Scanned Apps</a>
    </div>

  -->

</div>

<?php if ($qrCodePath): ?>
    <div class="text-center">
        <h3>Your QR Code</h3>
        <img src="<?php echo $qrCodePath; ?>" alt="QR Code" class="img-fluid mb-3">
        <form action="delete_qr.php" method="POST">
            <button type="submit" name="delete_qr" class="btn btn-danger">Delete QR Code</button>
        </form>
    </div>
<?php endif; ?>

<?php include 'footer.php'; ?>
