<?php
require 'vendor/autoload.php';
require 'db.php';

use OTPHP\TOTP;

session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit();
}

$user_id = $_SESSION['user_id'];

$stmt = $conn->prepare("SELECT id, secret FROM scanned_auths WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$otpList = [];
while ($row = $result->fetch_assoc()) {
    try {
        $totp = TOTP::create($row['secret']);
        $otpList[] = [
            'id' => $row['id'],
            'otp' => $totp->now()
        ];
    } catch (Exception $e) {
        // Handle invalid secrets if necessary
    }
}
$stmt->close();
$conn->close();

echo json_encode($otpList);
?>
