<?php
require "config.php";
require "verify_token.php"; // Ensure user is authenticated

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->app_name) || !isset($data->secret_key)) {
    echo json_encode(["status" => "error", "message" => "Missing required fields"]);
    exit;
}

$user_id = verifyToken(); // Get user ID from JWT
$app_name = htmlspecialchars($data->app_name);
$secret_key = htmlspecialchars($data->secret_key);

try {
    $stmt = $conn->prepare("INSERT INTO scanned_auths (app_name,user_id, secret) VALUES (?, ?, ?)");
    $stmt->execute([ $app_name, $user_id, $secret_key]);

    echo json_encode(["status" => "success", "message" => "QR code stored successfully"]);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
