<?php
require "config.php"; // Ensure config is loaded only once
require "../vendor/autoload.php";

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function verifyToken() {
  $headers = getallheaders();

if (!isset($headers["Authorization"])) {
http_response_code(401);
echo json_encode(["status" => "error", "message" => "Token missing"]);
exit;
}

// Remove "Bearer" and any extra spaces or new lines
$token = preg_replace('/\s+/', '', str_replace("Bearer", "", $headers["Authorization"]));

try {
$decoded = JWT::decode($token, new Key(JWT_SECRET_KEY, "HS256"));
return $decoded->sub; // Return user ID
} catch (Exception $e) {
http_response_code(401);
echo json_encode(["status" => "error", "message" => "Invalid token"]);
exit;
}


}

//print_r(getallheaders());
//exit;
?>
