<?php
require 'db.php'; // Database connection


function generateApiKey() {
    return bin2hex(random_bytes(32)); // Generates a 64-character secure API key
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $api_key = generateApiKey();

    // Validate input
    if (empty($username) || empty($email) || empty($password)) {
        die("All fields are required.");
    }



    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Insert into database
    $stmt = $conn->prepare("INSERT INTO users (username, email, password, api_key) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $username, $email, $hashedPassword, $api_key);

    if ($stmt->execute()) {
        echo "<script>alert('Registration successful! You can now log in.'); window.location='login.php';</script>";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}





?>
