<?php
session_start();
include 'db.php';

if (!isset($_SESSION['user_id']) || !isset($_POST['secret'])) {
    $_SESSION['flash_message'] = "❌ Invalid request.";
    header("Location: scan_qr.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$secret = trim($_POST['secret']);
$app_name = trim($_POST['app_name']);

if (!$secret) {
    die("❌ Error: Secret is empty.");
}

// ✅ Store the secret
$stmt = $conn->prepare("INSERT INTO scanned_auths (user_id, app_name, secret) VALUES (?, ?, ?)");
$stmt->execute([$user_id, $app_name, $secret]);

$stmt->close();
$conn->close();

$_SESSION['flash_message'] = "✅ QR Code scanned and saved!";
header("Location: dashboard.php");
exit();
